#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//boney tunnelMod01.fsh  by  mrange 
//https://www.shadertoy.com/view/3sGXzD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Based orignally upon: https://www.shadertoy.com/view/XdlSD4

// I always liked mandelbox_ryu made by EvilRyu
// Was tinkering a bit with the code and came up with this which at least I liked.
// https://www.shadertoy.com/view/3ddSDs

// Uses very simple occlusion based lighting which made it look more like a structure
// of bones than my other futile lighting attemps.

// Continued tinkering and applied camera path and domain repetition

const float fixed_radius2 = 4.5;
const float min_radius2   = 0.5;
const float folding_limit = 2.3;
const float scale         = -3.0;
const int   max_iter      = 120;
const vec3  bone          = vec3(0.89, 0.855, 0.788);
const vec3  rep           = vec3(10.0);

#define PATHA 0.4*vec2(0.11, 0.21)
#define PATHB 0.7*vec2(13.0, 3.0)

// Derived from https://www.shadertoy.com/view/XdcfR8
//  Another shade I really like

vec3 camPath(float z)  {
  return vec3(sin(z*PATHA)*PATHB, z);
}

vec3 camPathDeriv(float z)  {
  return vec3(PATHA*PATHB*cos(PATHA*z), 1.0);
}

vec3 camPathDeriv2(float z)  {
  return vec3(-PATHA*PATHA*PATHB*sin(PATHA*z), .0);
}

vec3 mod3(inout vec3 p, vec3 size) {
  vec3 c = floor((p + size*0.5)/size);
  p = mod(p + size*0.5, size) - size*0.5;
  return c;
}

void sphere_fold(float fr, inout vec3 z, inout float dz) {
  float r2 = dot(z, z);
  if(r2 < min_radius2) {
    float temp = (fr / min_radius2);
    z *= temp;
    dz *= temp;
  } else if(r2 < fr) {
    float temp = (fr / r2);
    z *= temp;
    dz *= temp;
  }
}

void box_fold(float fl, inout vec3 z, inout float dz) {
  z = clamp(z, -fl, fl) * 2.0 - z;
}

float sphere(vec3 p, float t) {
  return length(p)-t;
}

float torus(vec3 p, vec2 t) {
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float mb(float fl, float fr, vec3 z) {
  vec3 offset = z;
  float dr = 1.0;
  float fd = 0.0;
  for(int n = 0; n < 5; ++n) {
    box_fold(fl, z, dr);
    sphere_fold(fr, z, dr);
    z = scale * z + offset;
    dr = dr * abs(scale) + 1.0;        
    float r1 = sphere(z, 5.0);
    float r2 = torus(z, vec2(8.0, 1));        
    float r = n < 4 ? r2 : r1;        
    float dd = r / abs(dr);
    if (n < 3 || dd < fd) {
      fd = dd;
    }
  }
  return fd;
}

float df(vec3 p) { 
  float tm = p.z;
  vec3 wrap = camPath(tm);
  vec3 wrapDeriv = normalize(camPathDeriv(tm));
  p.xy -= wrap.xy;
  p -= wrapDeriv*dot(vec3(p.xy, 0), wrapDeriv)*0.5*vec3(1,1,-1);

  p -= rep*vec3(0.5, 0.0, 0.0);
  p.y *= (1.0 + 0.1*abs(p.y));
  vec3 i = mod3(p, rep);
  
  float fl = folding_limit + 0.3*sin(0.025*iTime+1.0)- 0.3; 
  float fr = fixed_radius2 - 3.0*cos(0.025*sqrt(0.5)*iTime-1.0);

  float d1 = mb(fl, fr, p);
  
  return d1; 
} 


float hash(vec2 p)  {
  float h = dot(p,vec2(127.1,311.7));   
  return fract(sin(h)*43758.5453123);
}

float intersect(vec3 ro, vec3 rd, out int iter) {
  float res;
  float r = hash(ro.xy + ro.xz + ro.yz);
  float t = 10.0*mix(0.01, 0.02, r);
  iter = max_iter;
    
  for(int i = 0; i < max_iter; ++i) {
    vec3 p = ro + rd * t;
    res = df(p);
    if(res < 0.001 * t || res > 20.) {
      iter = i;
      break;
    }
    t += res;
  }
    
  if(res > 20.) t = -1.;
  return t;
}

float ambientOcclusion(vec3 p, vec3 n) {
  float stepSize = 0.012;
  float t = stepSize;

  float oc = 0.0;

  for(int i = 0; i < 12; i++) {
    float d = df(p + n * t);
    oc += t - d;
    t += stepSize;
  }

  return clamp(oc, 0.0, 1.0);
}

vec3 normal(in vec3 pos) {
  vec3  eps = vec3(.001,0.0,0.0);
  vec3 nor;
  nor.x = df(pos+eps.xyy) - df(pos-eps.xyy);
  nor.y = df(pos+eps.yxy) - df(pos-eps.yxy);
  nor.z = df(pos+eps.yyx) - df(pos-eps.yyx);
  return normalize(nor);
}

vec3 lighting(vec3 p, vec3 rd, int iter) {
  vec3 n = normal(p);
  float fake = float(iter)/float(max_iter);
  float fakeAmb = exp(-fake*fake*9.0);
  float amb = ambientOcclusion(p, n);

  vec3 col = vec3(mix(1.0, 0.125, pow(amb, 3.0)))*vec3(fakeAmb)*bone;
  return col;
}

vec3 post(vec3 col, vec2 q) {
  col=pow(clamp(col,0.0,1.0),vec3(0.65)); 
  col=col*0.6+0.4*col*col*(3.0-2.0*col);  // contrast
  col=mix(col, vec3(dot(col, vec3(0.33))), -0.5);  // satuation
  col*=0.5+0.5*pow(19.0*q.x*q.y*(1.0-q.x)*(1.0-q.y),0.7);  // vigneting
  return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 q=fragCoord.xy/iResolution.xy; 
  vec2 uv = -1.0 + 2.0*q; 
  uv.x*=iResolution.x/iResolution.y; 
    
  float tm = 2.0*iTime;

  vec3 up = vec3(0.0, 1.0, 0.0) + 2.0*camPathDeriv2(tm);
    
  vec3 ro = camPath(tm);
  vec3 cf = normalize(camPathDeriv(tm));
  vec3 cs = normalize(cross(cf, up)); 
  vec3 cu = normalize(cross(cs,cf)); 
  vec3 rd = normalize(uv.x*cs + uv.y*cu + (3.0 - 1.0*length(uv))*cf);  // transform from view to world

  vec3 bg = mix(bone*0.5, bone, smoothstep(-1.0, 1.0, uv.y));
  vec3 col = bg;

  vec3 p=ro; 

  int iter = 0;
  
  float t = intersect(ro, rd, iter);
    
  if(t > -0.5) {
    p = ro + t * rd;
    col = lighting(p, rd, iter);
    col = mix(col, bg, 1.0-exp(-0.001*t*t)); 
  } 
    

  col=post(col, q);
  fragColor=vec4(col.x,col.y,col.z,1.0); 
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

